#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Tree BloomMod01.fsh  by  voz
//https://www.shadertoy.com/view/wsdGWH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



//-----------------CONSTANTS MACROS-----------------

#define PI 3.14159265359
#define E 2.7182818284
#define GR 1.61803398875
#define MAX_DIM (max(iResolution.x,iResolution.y))
#define FAR (PI*GR*E*5.)

//-----------------UTILITY MACROS-----------------

#define time ((sin(float(__LINE__))/PI/GR+1.0)*iTime/PI/GR/E)
#define sphereN(uv) (clamp(1.0-length(uv*2.0-1.0), 0.0, 1.0))
#define clip(x) (smoothstep(0.0, 1.0, x))
#define TIMES_DETAILED (1.0)
#define angle(uv) (atan(uv.y, uv.x))
#define angle_percent(uv) ((angle(uv)/PI+1.0)/2.0)
#define hash(p) (fract(sin(vec2( dot(p,vec2(127.5,313.7)),dot(p,vec2(239.5,185.3))))*43458.3453))

#define flux(x) (vec3(cos(x),cos(4.0*PI/3.0+x),cos(2.0*PI/3.0+x))*.5+.5)
#define rormal(x) (normalize(sin(vec3(time, time/GR, time*GR)+seedling)*.25+.5))
#define rotatePoint(p,n,theta) (p*cos(theta)+cross(n,p)*sin(theta)+n*dot(p,n) *(1.0-cos(theta)))
#define circle(x) (vec2(cos((x)*PI), sin((x)*PI)))
#define saw(x) fract( sign( 1.- mod( abs(x), 2.) ) * abs(x) )

#define TAO 6.283
vec2 Rotate(in vec2 v, float angle) {return v*mat2(cos(angle),sin(angle),-sin(angle),cos(angle));}
vec2 Kaleido(in vec2 v,float power){return Rotate(v,floor(.5+atan(v.x,-v.y)*power/TAO)*TAO/power);}
float HTorus(in vec3 z, float radius1, float radius2){return max(-z.y-0.055,length(vec2(length(z.xy)-radius1,z.z))-radius2-z.x*0.035);}

mat2 rot(float x) {
    return mat2(cos(x), sin(x), -sin(x), cos(x));
}

float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
vec3 mcol;
float dB;
float dfScene(in vec3 z0){
	vec4 z=vec4(z0,1.0);
	float d=max(abs(z.y+1.0)-1.0,length(z.xz)-0.13);
	for(int i=0;i<5;i++){
		z.xz=Kaleido(z.xz,float(i+2)*2.);
		z.yz=Rotate(z.yz,(saw(time*PI)-1.));
		
        float dcap = sdCapsule(z.xyz+vec3(0., 0., 1.), vec3(0.,0.,1.), vec3(0.,2.0,0.),0.1);
        dB += dcap/z.w/10.;
		d=min(d,dcap/z.w);
		z.z+=1.0;
        z.y -= 2.;
		z*=vec4(2.0,2.0,2.0,2.0);
	}
	//dB=(length(z.xyz)-1.0)/z.w;
	return d;
}

vec3 surfaceNormal(vec3 p, vec3 rd) { 
    vec2 e = vec2(5.0 / iResolution.y, 0);
	float d1 = dfScene(p + e.xyy), d2 = dfScene(p - e.xyy);
	float d3 = dfScene(p + e.yxy), d4 = dfScene(p - e.yxy);
	float d5 = dfScene(p + e.yyx), d6 = dfScene(p - e.yyx);
	float d = dfScene(p) * 2.0;	
    return normalize(vec3(d1 - d2, d3 - d4, d5 - d6));
}

//IQ
float calcAO(vec3 pos, vec3 nor, vec3 rd) {   
    float occ = 0.0;
    float sca = 1.0;
    for(int i = 0; i < 5; i++) {
        float hr = 0.01 + 0.05*float(i);
        vec3 aopos = pos + nor*hr;
        occ += smoothstep(0.0, 0.7, hr - dfScene(aopos)) * sca;
        sca *= 0.97;
    }
    return clamp(1.0 - 3.0 * occ , 0.0, 1.0);
}

//main march
vec3 marchScene(vec3 ro, vec3 rd) {
    
    vec3 pc = vec3(0.0); //returned pixel colour
    float d = 0.0; //distance marched
    vec3 rp = vec3(0.0); //ray position
    vec3 lp = normalize(vec3(5.0, 8.0, -3.0)); //light position
   
    for (int i = 0; i < 64; i++) {
        rp = ro + rd * d;
        float ns = dfScene(rp);
        d += ns;
        if (ns < 1.0/MAX_DIM || d > FAR) break;
    }
    
    if (d < FAR) {

        vec3 sc = flux(dB+time); //surface colour
        vec3 n = surfaceNormal(rp, rd);
        float ao = calcAO(rp, n, rd);
        
        float diff = max(dot(n, lp), 0.0); //diffuse
	    pc = sc * 0.5 + diff * sc * ao;
        float spe = pow(max(dot(reflect(rd, n), lp), 0.), 16.); //specular.
        pc = sc;//pc + spe * vec3(1.0);
    }
    
    return pc;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    
    //coordinate system
    vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    //camera
    vec3 rd = normalize(vec3(uv, 2.));
    vec3 ro = vec3(0.0, 1./GR, -PI)*2.;
    
    //rotate camera
    ro.yz *= rot(sin(iTime) * 0.25);
    rd.yz *= rot(sin(iTime) * 0.25); 
    ro.xz *= rot(iTime * 0.5);
    rd.xz *= rot(iTime * 0.5);
    //*/
    
    
    fragColor = vec4(marchScene(ro, rd), 1.0);    
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

